#pragma once
#include <windows.h>	//	for RECT

class CBitmapFontData;

class CBitmapFont
{
private:
	CBitmapFontData*	m_pData;

	float m_fScaleX;
	float m_fScaleY;

public:

	CBitmapFont(void);
	CBitmapFont(CBitmapFontData* pData);

	int GetCharWidth(void);	
	int GetCharHeight(void);

	float GetScaleX(void)			{ return m_fScaleX; }
	void SetScaleX(float fScaleX)	{ m_fScaleX = fScaleX; }

	float GetScaleY(void)			{ return m_fScaleY; }
	void SetScaleY(float fScaleY)	{ m_fScaleY = fScaleY; }

	void DrawString(const char* szText, int nPosX, int nPosY, DWORD color = 0xffffffff);
	void DrawStringCenter(const char* szText, int nPosX, int nPosY, DWORD color = 0xffffffff);

	void LoadKerning(const char* szFilename);

};